;;; -*- Mode:Common-Lisp; Package:MACTOOLBOX; Base:10; Fonts:(CPTFONT HL10B HL12I CPTFONT CPTFONTB) -*-

;;;			    RESTRICTED RIGHTS LEGEND
;;; Use, duplication, or disclosure by the Government is subject to restrictions as
;;; set forth in subdivision (c)(1)(ii) of the Rights in Technical Data and 
;;; Computer Software clause at 52.227-7013.
;;; 	 TEXAS INSTRUMENTS INCORPORATED, P.O. BOX 2909, AUSTIN, TEXAS 78769
;;; 1     *Copyright (C) 1989 Texas Instruments Incorporated. 1 *All rights reserved.


(defun 4ACTIVE-POINTER-P *(object)
  "2Returns true if OBJECT is a TB:MAC-POINTER instance with an active,
i.e., non-disposed, pointer.*"
  (and (typep object 'mac-pointer)
       (typep (send object :pointer) '(integer 0 *))))


(defun 4NONNIL-ACTIVE-POINTER-P *(object)
  "2Returns true if OBJECT is a TB:MAC-POINTER instance with an active,
i.e., non-disposed, pointer which is non-NIL.*"
  (and (typep object 'mac-pointer)
       (typep (send object :pointer) '(integer 1 *))))


(defun 4DISPOSE-POINTER-MAYBE *(object)
  "2Dispose of OBJECT if it is a MAC-POINTER object which has not previoused been disposed and
is non-NIL.*"
  (declare (inline nonnil-active-pointer-p))
  (when (nonnil-active-pointer-p object)
    (!DisposPtr object)))


(defun 4!NILPTR-P *(object)
  "2Returns true if OBJECT is an active TB:MAC-POINTER instance pointing to NIL.*"
  (declare (inline active-pointer-p))
  (and (active-pointer-p object)
       (zerop (send object :pointer))))


(defun 4MAKE-POINTER *(&optional (macintosh-address 0))
  "2Returns a TB:MAC-POINTER instance with :POINTER intialized to MACINTOSH-ADDRESS.*"
  (make-instance 'mac-pointer :pointer macintosh-address))


(defun 4ACTIVE-HANDLE-P *(object)
  "2Returns true if OBJECT is a TB:MAC-HANDLE instance with an active,
i.e.,  non-disposed, handle.*"
  (and (typep object 'mac-pointer)
       (typep (send object :handle) '(integer 0 *))))


(defun 4NONNIL-ACTIVE-HANDLE-P *(object)
  "2Returns true if OBJECT is a TB:MAC-HANDLE instance with an active,
i.e.,  non-disposed, handle which is non-NIL.*"
  (and (typep object 'mac-pointer)
       (typep (send object :handle) '(integer 1 *))))


(defun 4DISPOSE-HANDLE-MAYBE *(object)
  "2Dispose of OBJECT if it is a MAC-HANDLE object which has not previoused been disposed 
and is non-NIL.*"
  (declare (inline nonnil-active-handle-p))
  (when (nonnil-active-handle-p object)
    (!DisposHandle object)))


(defun 4!NILHNDL-P *(object)
  "2Returns true if OBJECT is an active TB:MAC-HANDLE instance pointing  indirectly to NIL.*"
  (declare (inline active-handle-p))
  (and (active-handle-p object)
       (zerop (send object :handle))))


(defun 4ADDRESS-EQ *(object-1 object-2)
  "2Returns true if arguements are handles or pointers (mixed or matched) which 
ultimately refer to the same Macintosh address.*"
  (declare (inline active-handle-p active-pointer-p))
  (cond ((active-handle-p object-1)
	 (cond ((active-handle-p object-2)
		;1; case of (eq handle-1 handle-2)*
		(or (eq object-1 object-2)
		    (= (send object-1 :handle) (send object-2 :handle))
		    (= (logand #xFFFFFF 
			       (fetch (make-instance 'mac-pointer :pointer 
						    (send object-1 :handle)) 0))
		       (logand #xFFFFFF
			       (fetch (make-instance 'mac-pointer :pointer 
						    (send object-2 :handle)) 0)))))
	       ((active-pointer-p object-2)
		;1;case of (eq handle-1 pointer-2)*
		(= (logand #xFFFFFF 
			       (fetch (make-instance 'mac-pointer :pointer 
						     (send object-1 :handle)) 0))
		   (send object-2 :pointer)))
	       (t nil)))			       ;1object-2 not a handle or pointer*
	((active-pointer-p object-1)
	 (cond ((active-handle-p object-2)
		;1; case of (eq pointer-1 handle-2)*
		(= (send object-1 :pointer)
		   (logand #xFFFFFF 
			       (fetch (make-instance 'mac-pointer :pointer 
						     (send object-2 :handle)) 0))))
	       ((active-pointer-p object-2)
		;1; case of (eq pointer-1 pointer-2)*
		(or (eq object-1 object-2)
		    (= (send object-1 :pointer) (send object-2 :pointer))))
	       (t nil)))			       ;1object-2 not a handle or pointer*
	(t nil))				       ;1object-1  not a handle or pointer*
  );1;address-eq

3(**provide "TOOLBOX-AUX-FUNCTIONS")
